/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.items.ItemWaypointCompass;
import jds.bibliocraft.models.ModelAtlasCompass;
import jds.bibliocraft.models.ModelAtlasCover;
import jds.bibliocraft.models.ModelCompass;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemAtlasRenderer
implements IItemRenderer {
    private ModelAtlasCover modelAtlas = new ModelAtlasCover();
    private ModelAtlasCompass modelAtlasCompass = new ModelAtlasCompass();
    private ModelCompass modelCompass = new ModelCompass();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case FIRST_PERSON_MAP: {
                return true;
            }
            case INVENTORY: {
                NBTTagCompound tags = item.func_77978_p();
                if (tags == null) break;
                byte savedComp = -1;
                if (tags.func_74764_b("savedCompass")) {
                    savedComp = tags.func_74762_e("savedCompass");
                }
                NBTTagList tagList = tags.func_150295_c("Inventory", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    ItemStack invStack;
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    byte slot = tag.func_74771_c("Slot");
                    if (slot < 0 || slot >= 6 || (invStack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null || !(invStack.func_77973_b() instanceof ItemWaypointCompass) || savedComp != slot) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            MapData mapdata = this.getMapData(item);
            if (mapdata != null) {
                Minecraft.func_71410_x().field_71460_t.func_147701_i().func_148250_a(mapdata, false);
            }
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.ATLASCOVER);
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-5.2, (double)-0.0, (double)-0.0);
            float scaler = 128.0f;
            GL11.glScalef((float)scaler, (float)scaler, (float)scaler);
            GL11.glTranslated((double)0.012, (double)1.0, (double)0.0);
            this.modelAtlas.renderAtlas();
            this.renderPins(item);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            float rotateAngle = 0.0f;
            NBTTagCompound tags = item.func_77978_p();
            if (tags != null && tags.func_74764_b("needleAngle")) {
                rotateAngle = tags.func_74760_g("needleAngle");
            }
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)30.0f, (float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.6f, (float)1.6f, (float)1.6f);
            GL11.glTranslatef((float)-0.03f, (float)-0.0f, (float)-0.0f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.ATLASITEM);
            this.modelAtlasCompass.renderBook();
            GL11.glTranslatef((float)0.1f, (float)-0.1f, (float)0.0f);
            GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.WAYPOINTCOMPASS_PNG);
            this.modelAtlasCompass.renderCompassFace();
            GL11.glRotatef((float)rotateAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            this.modelAtlasCompass.renderNeedle();
            GL11.glPopMatrix();
        }
    }

    private void renderPins(ItemStack stack) {
        ItemStack map = this.getAtlasCurrentMap(stack);
        NBTTagCompound tags = stack.func_77978_p();
        if (map != null && tags != null && tags.func_74764_b("maps")) {
            NBTTagList mapList = tags.func_150295_c("maps", 10);
            for (int i = 0; i < mapList.func_74745_c(); ++i) {
                NBTTagCompound mapTag = mapList.func_150305_b(i);
                if (!mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals("Map_" + map.func_77960_j()) || !mapTag.func_74764_b("xMapWaypoints") || !mapTag.func_74764_b("yMapWaypoints") || !mapTag.func_74764_b("MapWaypointColors")) continue;
                NBTTagList mapXPins = mapTag.func_150295_c("xMapWaypoints", 5);
                NBTTagList mapYPins = mapTag.func_150295_c("yMapWaypoints", 5);
                NBTTagList mapPinColors = mapTag.func_150295_c("MapWaypointColors", 5);
                float x = 0.0f;
                float y = 0.0f;
                float color = 0.0f;
                for (int n = 0; n < mapXPins.func_74745_c(); ++n) {
                    x = mapXPins.func_150308_e(n);
                    y = mapYPins.func_150308_e(n);
                    color = mapPinColors.func_150308_e(n);
                    FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getColorTexture((int)color));
                    GL11.glTranslatef((float)0.0f, (float)y, (float)x);
                    this.modelAtlas.renderPin();
                    GL11.glTranslatef((float)0.0f, (float)(-y), (float)(-x));
                }
            }
        }
    }

    private ItemStack getAtlasCurrentMap(ItemStack stack) {
        int mapSlot;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null && (mapSlot = tags.func_74762_e("mapSlot")) >= 0) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 216);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            ItemStack invStack = atlasInventory.func_70301_a(mapSlot);
            return invStack;
        }
        return null;
    }

    private MapData getMapData(ItemStack stack) {
        MapData mapdata;
        ItemStack invStack;
        int mapSlot;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null && (mapSlot = tags.func_74762_e("mapSlot")) >= 0 && (invStack = this.getAtlasCurrentMap(stack)) != null && invStack.func_77973_b() instanceof ItemMap && (mapdata = Items.field_151098_aY.func_77873_a(invStack, (World)Minecraft.func_71410_x().field_71441_e)) != null) {
            return mapdata;
        }
        return null;
    }

    public ResourceLocation getColorTexture(float color) {
        int colorint = (int)color;
        switch (colorint) {
            case 0: {
                return CommonProxy.BLACKWOOL;
            }
            case 1: {
                return CommonProxy.REDWOOL;
            }
            case 2: {
                return CommonProxy.GREENWOOL;
            }
            case 3: {
                return CommonProxy.LIMEWOOL;
            }
            case 4: {
                return CommonProxy.BROWNWOOL;
            }
            case 5: {
                return CommonProxy.BLUEWOOL;
            }
            case 6: {
                return CommonProxy.CYANWOOL;
            }
            case 7: {
                return CommonProxy.LBLUEWOOL;
            }
            case 8: {
                return CommonProxy.PURPLEWOOL;
            }
            case 9: {
                return CommonProxy.MAGENTAWOOL;
            }
            case 10: {
                return CommonProxy.PINKWOOL;
            }
            case 11: {
                return CommonProxy.YELOOWWOOL;
            }
            case 12: {
                return CommonProxy.ORANGEWOOL;
            }
            case 13: {
                return CommonProxy.GRAYWOOL;
            }
            case 14: {
                return CommonProxy.LGRAYWOOL;
            }
            case 15: {
                return CommonProxy.WHITEWOOL;
            }
        }
        return CommonProxy.REDWOOL;
    }
}

